﻿$(document).ready(function(){

//----------  НАСТРОЙКИ  -----------//

var button      = '#slidx-button'; // id элемента, нажатие на который - вызывает меню
var menu        = '.slidx-menu';   // id блока меню
var mode        = 'click'          // открывать меню при: 'click' - нажатии на кнопку; 'hover' - при наведении
var side        = 'right'          // с какой стороны будет меню ('right' o 'left')
var shadow      = 'yes'            // затемннение основной части страницы при открытии меню ('yes' o 'no')
var opacity     = 0.6;             // непрозрачность затемнения (меньше = прозрачней)
var size        = 250;             // ширина меню в px
var speed       = 0.5;             // скорость открытия и закрытия (в сек.)
var normalTime  = 0;               // задержка при открытии/закрытии (в мс. рекомендуется оставлять 0).
var menuTime    = 300;             // таймер закрытия меню после нажатия на один из пунктов (в мс.).
var speedM      = speed * 1000;

//----------  СТИЛИ CSS  -----------//

$(menu).css({
'position'   : 'fixed',
'top'        : '0px',
'width'      : size + 'px',
'max-width'  : '100%',
'height'     : '100%',
'overflow-y' : 'auto',
'transition' : speed + 's',
'z-index'    : 98,
});
if (side == 'right') {
$(menu).css({'right': '-' + size + 'px',})
}
if (side !== 'right') {
$(menu).css({'left': '-' + size + 'px',})
}
$(button).css({
'position'   : 'fixed',
'top'        : '0px',
'transition' : speed + 's',
'z-index'    : 97,
});
if (side == 'right') {
$(button).css({'right': '0px',})
}
if (side !== 'right') {
$(button).css({'left': '0px',})
}

//----------  ФУНКЦИИ  -----------//

function open(){
if (side == 'right') {
$(menu).animate({
right: '0',
}, normalTime );
if (mode == 'click') {
$(button).animate({
right: size,
}, normalTime );
}
}
if (side !== 'right') {
$(menu).animate({
left: '0',
}, normalTime );
if (mode == 'click') {
$(button).animate({
left: size,
}, normalTime );
}
}
$(menu).addClass('slidx-open');
if (shadow == 'yes') {
$("<div>",{
id: "slidx-shadow",
css: 
{
"position": "fixed",
"top": "0px",
"width": "100%",
"height": "100%",
"background-color": "#000",
"opacity": "0",
"z-index": "96",
},
}).appendTo('html');
$('#slidx-shadow').fadeTo(speedM, opacity);
}
};
function close(delayTime){
if (side == 'right') {
$(menu).animate({
right: '-' + size,
}, delayTime)
if (mode == 'click') {
$(button).animate({
right: 0,
}, delayTime);
}
}
if (side !== 'right') {
$(menu).animate({
left: '-' + size,
}, delayTime)
if (mode == 'click') {
$(button).animate({
left: 0,
}, delayTime);
}
}
$(menu).removeClass('slidx-open');
$('#slidx-shadow').fadeOut(speedM);
};

//----- Режим CLICK -----//

if (mode == 'click') {
$(button).click(function() {
if (!$(menu).hasClass('slidx-open')) {
open();
}
else {
close(normalTime);
} 
});
$(menu).click(function() {
close(menuTime);
});
}
$(document).on('click', '#slidx-shadow', function() {
close(normalTime);
});

//----- Режим HOVER -----//

if (mode == 'hover') {
$(button).mouseover(function() {
if (!$(menu).hasClass('slidx-open')) {
open();
}
else {
close(normalTime);
} 
});
$(menu).mouseleave(function() {
close(normalTime);
});
$(menu).click(function() {
close(menuTime);
});
};
});